﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;

namespace Grupa_A
{
    public partial class Form1 : Form
    {
        int[,] podaci = new int[10991, 4];
        int indeksRetkaZaPrikaz = 0;

        public Form1()
        {
            InitializeComponent();
        }

        private void btnUcitaj_Click(object sender, EventArgs e)
        {
            try
            {
                StreamReader reader = new StreamReader("podaciA.txt");
                int trenutniRedak = 0;

                while (!reader.EndOfStream)
                {
                    string linija = reader.ReadLine();
                    string[] dijeloviLinije = linija.Split(';');

                    podaci[trenutniRedak, 0] = Convert.ToInt32(dijeloviLinije[0]);
                    podaci[trenutniRedak, 1] = Convert.ToInt32(dijeloviLinije[1]);
                    podaci[trenutniRedak, 2] = Convert.ToInt32(dijeloviLinije[2]);
                    podaci[trenutniRedak, 3] = Convert.ToInt32(dijeloviLinije[3]);

                    trenutniRedak++;
                }

                reader.Close();

                MessageBox.Show("Podaci su učitani!");
            }
            catch (Exception ex)
            {
                MessageBox.Show("Greška: " + ex.Message);
            }
        }
        private void btnZapocni_Click(object sender, EventArgs e)
        {
            timer1.Enabled = true;
        }

        private void btnZavrsi_Click(object sender, EventArgs e)
        {
            timer1.Enabled = false;
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
            string sati = Convert.ToString(podaci[indeksRetkaZaPrikaz, 1]);
            string minute = Convert.ToString(podaci[indeksRetkaZaPrikaz, 2]);
            string sekunde = Convert.ToString(podaci[indeksRetkaZaPrikaz, 3]);
            string brzina = Convert.ToString(podaci[indeksRetkaZaPrikaz, 0]);

            labVrijeme.Text = sati + ":" + minute + ":" + sekunde;
            labBrzina.Text = brzina + " km/h";

            indeksRetkaZaPrikaz++;
        }

        double[] izracunajProsjek(int b, int e)
        {
            int sumaBrzina = 0;
            int brojBrzina = 0;

            for (int i = 0; i < podaci.GetLength(0); i++)
            {
                if (podaci[i, 1] >= b && podaci[i, 1] < e)
                {
                    sumaBrzina += podaci[i, 0];
                    brojBrzina++;
                }
            }

            double prosjecnaBrzina = sumaBrzina / Convert.ToDouble(brojBrzina);

            double[] rezultat = new double[2];
            rezultat[0] = prosjecnaBrzina;
            rezultat[1] = brojBrzina;

            return rezultat;
        }

        private void btnObradi_Click(object sender, EventArgs e)
        {
            int pocetniSat = Convert.ToInt32(txtPocetni.Text);
            int krajnjiSat = Convert.ToInt32(txtKrajnji.Text);

            double[] obrada = izracunajProsjek(pocetniSat, krajnjiSat);

            txtProsjek.Text = Convert.ToString(obrada[0]);
            txtBrojPodataka.Text = Convert.ToString(obrada[1]);
        }
    }
}